/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

#ifndef MX__FOPS_H
#define MX__FOPS_H

#ifdef MX_KERNEL

#include "mx_klib.h"

#else /* MX_KERNEL */

#include <stddef.h>

MX_FUNC(mx_return_t) mx__open(int unit, int endpoint, mx_endpt_handle_t *handlr);
MX_FUNC(int) mx__close(mx_endpt_handle_t handle);

#if MX_OS_MACOSX || MX_OS_WINNT
#define MX_MAP_FAILED ((void*)-1L)
#else
#include <sys/mman.h>
#define MX_MAP_FAILED MAP_FAILED /* sus says it is defined in sys/mman.h */
#endif
void *mx__mmap(void *start, size_t length, mx_endpt_handle_t handle,
	       ptrdiff_t offset, int read_only);
int mx__munmap(void *start, size_t length);
int mx__ioctl(mx_endpt_handle_t handle, int cmd, void *buf, size_t bufsize);

int mx__map(struct mx_endpoint *ep);
void mx__unmap(struct mx_endpoint *ep);

#endif /* MX_KERNEL */

MX_FUNC(mx_return_t) mx_open_board(int i, mx_endpt_handle_t *handle);
MX_FUNC(mx_return_t) mx_open_any_board(mx_endpt_handle_t *rethandle);
MX_FUNC(mx_return_t) mx_open_ctl(int priv,
				 mx_endpt_handle_t *handle);

#endif
